<?php
/* Smarty version 5.4.2, created on 2024-12-17 16:50:33
  from 'file:../../../apps/psl/views/loan-calculator.tpl' */

/* @var \Smarty\Template $_smarty_tpl */
if ($_smarty_tpl->getCompiled()->isFresh($_smarty_tpl, array (
  'version' => '5.4.2',
  'unifunc' => 'content_6761f2290652a8_89278246',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    'c3ea0b58955276f442c42a830f45591ead059ba4' => 
    array (
      0 => '../../../apps/psl/views/loan-calculator.tpl',
      1 => 1734472231,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
  ),
))) {
function content_6761f2290652a8_89278246 (\Smarty\Template $_smarty_tpl) {
$_smarty_current_dir = '/Users/razib/Herd/suite/apps/psl/views';
?><!DOCTYPE html>
<html>
<head>
    <title>Loan Application Form</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <style>
        body {
            background-color: #f8f9fa;
            color: #333;
        }

        .form-container {
            max-width: 1200px;
            margin: 2rem auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
            padding: 2rem;
        }

        .section-header {
            background: #f8f9fa;
            padding: 1rem;
            margin: 2rem -2rem;
            border-left: 4px solid #0d6efd;
        }

        .form-label {
            font-weight: 500;
            color: #495057;
        }

        .form-control, .form-select {
            border: 1px solid #ced4da;
            border-radius: 6px;
            padding: 0.75rem;
            transition: all 0.2s;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.15);
        }

        .card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
            margin-bottom: 1.5rem;
        }

        .card-header {
            background: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
            padding: 1rem 1.25rem;
        }

        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 6px;
            font-weight: 500;
        }

        .btn-primary {
            background-color: #0d6efd;
            border: none;
            transition: all 0.2s;
        }

        .btn-primary:hover {
            background-color: #0b5ed7;
            transform: translateY(-1px);
        }

        .loan-calculator {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .loan-calculator h3 {
            color: #0d6efd;
            margin-bottom: 1.5rem;
        }

        .input-group {
            margin-bottom: 1rem;
        }

        .input-group .btn {
            padding: 0.375rem 0.75rem;
        }

        .monthly-payment {
            font-size: 1.5rem;
            color: #0d6efd;
            font-weight: bold;
        }

        /* Custom tooltip styling */
        .info-tooltip {
            color: #6c757d;
            font-size: 14px;
            margin-left: 0.5rem;
            cursor: pointer;
        }

        /* File upload area styling */
        .upload-area {
            border: 2px dashed #ced4da;
            border-radius: 8px;
            padding: 2rem;
            text-align: center;
            background: #f8f9fa;
            cursor: pointer;
            transition: all 0.2s;
        }

        .upload-area:hover {
            border-color: #0d6efd;
            background: #f1f3f5;
        }

        /* Validation styles */
        .was-validated .form-control:invalid {
            border-color: #dc3545;
            background-image: url("data:image/svg+xml,...");
        }

        .was-validated .form-control:valid {
            border-color: #198754;
            background-image: url("data:image/svg+xml,...");
        }

        /* Loading spinner */
        .spinner-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
    </style>
</head>
<body>
<div class="spinner-overlay">
    <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
</div>

<div class="container form-container">
    <h2 class="text-center mb-4">Loan Application</h2>

    <form id="app_form" method="post" action="https://suite.test/?ng=psl/app/save-application" class="needs-validation" novalidate>
        <!-- Loan Calculator Section -->
        <div class="loan-calculator">
            <h3>Loan Calculator</h3>
            <div class="row">
                <div class="col-md-4">
                    <label class="form-label">Loan Amount ($)</label>
                    <div class="input-group">
                        <button class="btn btn-outline-secondary" id="decreaseAmount" type="button">-</button>
                        <input type="number" class="form-control" id="loanAmount" name="loan_amount" value="1000">
                        <button class="btn btn-outline-secondary" id="increaseAmount" type="button">+</button>
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Term (months)</label>
                    <div class="input-group">
                        <button class="btn btn-outline-secondary" id="decreaseTerm" type="button">-</button>
                        <input type="number" class="form-control" id="loanTerm" name="loan_term" value="12">
                        <button class="btn btn-outline-secondary" id="increaseTerm" type="button">+</button>
                    </div>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Interest Rate (%)</label>
                    <div class="input-group">
                        <button class="btn btn-outline-secondary" id="decreaseRate" type="button">-</button>
                        <input type="number" class="form-control" id="interestRate" readonly name="interest_rate" value="20">
                        <button class="btn btn-outline-secondary" id="increaseRate" type="button">+</button>
                    </div>
                </div>
            </div>
            <div class="text-center mt-4">
                <h4>Monthly Payment: <span class="monthly-payment">$<span id="monthlyPayment">0.00</span></span></h4>
            </div>
        </div>

        <!-- Personal Information Section -->
        <div class="section-header">
            <h3 class="mb-0">Personal Information</h3>
        </div>

        <!-- Form sections continue with existing fields but styled according to the new design -->

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-primary btn-lg">Submit Application</button>
        </div>
    </form>
</div>

<!-- JavaScript for form handling -->
<?php echo '<script'; ?>
>
    
    document.addEventListener('DOMContentLoaded', function() {
        // Existing calculator functionality stays the same

        // Form validation
        const form = document.getElementById('app_form');

        form.addEventListener('submit', async function(e) {
            e.preventDefault();

            if (!form.checkValidity()) {
                e.stopPropagation();
                form.classList.add('was-validated');
                return;
            }

            const spinner = document.querySelector('.spinner-overlay');
            spinner.style.display = 'flex';

            try {
                const formData = new FormData(form);
                const response = await fetch(form.action, {
                    method: 'POST',
                    body: formData
                });

                const result = await response.json();

                if (result.status === 'success') {
                    window.location = 'https://suite.test/psl/app/loan-application-form/submitted';
                } else {
                    alert(result.message || 'An error occurred');
                }
            } catch (error) {
                alert('An error occurred while submitting the form');
            } finally {
                spinner.style.display = 'none';
            }
        });

        // Input masking and validation
        const phoneInput = document.getElementById('phone');
        phoneInput?.addEventListener('input', function(e) {
            let x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
            e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
        });

        const ssnInput = document.getElementById('ssn');
        ssnInput?.addEventListener('input', function(e) {
            let x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,2})(\d{0,4})/);
            e.target.value = !x[2] ? x[1] : x[1] + '-' + x[2] + (x[3] ? '-' + x[3] : '');
        });
    });
    

<?php echo '</script'; ?>
>
</body>
</html><?php }
}
