<?php

/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/

if (!defined('APP_RUN')) {
    exit('No direct access allowed');
}

_auth();
$ui->assign('selected_navigation', 'util');
$ui->assign('_title', __('AI') . '- ' . $config['CompanyName']);
$action = route(1, 'responses');
$user = User::_info();
$ui->assign('user', $user);

if (!has_access($user->roleid, 'hr', 'view')) {
    permissionDenied();
}

switch ($action) {

    case 'responses':
        $responses = AiResponse::all();

        view('ai-responses', [
            'responses' => $responses,
        ]);

        break;

        case 'response':

            $uuid = route(2);

            $response = AiResponse::where('uuid', $uuid)->first();

            if(!$response)
            {
                abort(404);
            }

            view('ai-response', [
                'response' => $response,
            ]);

            break;

            case 'delete':
                $id = route(3);
                $response = AiResponse::find($id);
                if($response)
                {
                    $response->delete();
                    r2(U . 'ai/responses', 's', $_L['delete_successful']);
                }
                break;

    default:
        abort(404);
        break;

}