<?php
use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $table = 'sys_currencies';

    public static function convert($from, $to, $amount = 1)
    {
        $client = new GuzzleHttp\Client([
            'base_uri' => 'http://download.finance.yahoo.com/d/',
        ]);

        $response = $client->request(
            'GET',
            'quotes.csv?s=' . $from . $to . '=X&f=nl1d1t1'
        );
    }

    public static function list_all($format = 'json')
    {
        $json = '[
  {
    "symbol": "$",
    "name": "US Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "USD",
    "name_plural": "US dollars"
  },
  {
    "symbol": "CA$",
    "name": "Canadian Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "CAD",
    "name_plural": "Canadian dollars"
  },
  {
    "symbol": "€",
    "name": "Euro",
    "symbol_native": "€",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "EUR",
    "name_plural": "euros"
  },
  {
    "symbol": "AED",
    "name": "United Arab Emirates Dirham",
    "symbol_native": "AED",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "AED ",
    "name_plural": "UAE dirhams"
  },
  {
    "symbol": "Af",
    "name": "Afghan Afghani",
    "symbol_native": "؋",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "AFN",
    "name_plural": "Afghan Afghanis"
  },
  {
    "symbol": "ALL",
    "name": "Albanian Lek",
    "symbol_native": "Lek",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "ALL",
    "name_plural": "Albanian lekë"
  },
  {
    "symbol": "AMD",
    "name": "Armenian Dram",
    "symbol_native": "դր.",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "AMD",
    "name_plural": "Armenian drams"
  },
  {
    "symbol": "AR$",
    "name": "Argentine Peso",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "ARS",
    "name_plural": "Argentine pesos"
  },
  {
    "symbol": "AU$",
    "name": "Australian Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "AUD",
    "name_plural": "Australian dollars"
  },
  {
    "symbol": "man.",
    "name": "Azerbaijani Manat",
    "symbol_native": "ман.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "AZN",
    "name_plural": "Azerbaijani manats"
  },
  {
    "symbol": "KM",
    "name": "Bosnia-Herzegovina Convertible Mark",
    "symbol_native": "KM",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BAM",
    "name_plural": "Bosnia-Herzegovina convertible marks"
  },
  {
    "symbol": "Tk",
    "name": "Bangladeshi Taka",
    "symbol_native": "৳",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BDT",
    "name_plural": "Bangladeshi takas"
  },
    {
    "symbol": "$",
    "name": "Barbadian dollar",
    "symbol_native": "Bds$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BBD",
    "name_plural": "Barbadian dollars"
  },
  {
    "symbol": "BGN",
    "name": "Bulgarian Lev",
    "symbol_native": "лв.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BGN",
    "name_plural": "Bulgarian leva"
  },
  {
    "symbol": "BD",
    "name": "Bahraini Dinar",
    "symbol_native": "د.ب.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "BHD",
    "name_plural": "Bahraini dinars"
  },
  {
    "symbol": "FBu",
    "name": "Burundian Franc",
    "symbol_native": "FBu",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "BIF",
    "name_plural": "Burundian francs"
  },
  {
    "symbol": "BN$",
    "name": "Brunei Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BND",
    "name_plural": "Brunei dollars"
  },
  {
    "symbol": "Bs",
    "name": "Bolivian Boliviano",
    "symbol_native": "Bs",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BOB",
    "name_plural": "Bolivian bolivianos"
  },
  {
    "symbol": "R$",
    "name": "Brazilian Real",
    "symbol_native": "R$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BRL",
    "name_plural": "Brazilian reals"
  },
  {
    "symbol": "BWP",
    "name": "Botswanan Pula",
    "symbol_native": "P",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BWP",
    "name_plural": "Botswanan pulas"
  },
  {
    "symbol": "BYR",
    "name": "Belarusian Ruble",
    "symbol_native": "BYR",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "BYR",
    "name_plural": "Belarusian rubles"
  },
  {
    "symbol": "BZ$",
    "name": "Belize Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "BZD",
    "name_plural": "Belize dollars"
  },
  {
    "symbol": "CDF",
    "name": "Congolese Franc",
    "symbol_native": "FrCD",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "CDF",
    "name_plural": "Congolese francs"
  },
  {
    "symbol": "CHF ",
    "name": "Swiss Franc",
    "symbol_native": "CHF",
    "decimal_digits": 2,
    "rounding": 0.05,
    "code": "CHF",
    "name_plural": "Swiss francs"
  },
  {
    "symbol": "CL$",
    "name": "Chilean Peso",
    "symbol_native": "$",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "CLP",
    "name_plural": "Chilean pesos"
  },
  {
    "symbol": "CN¥",
    "name": "Chinese Yuan",
    "symbol_native": "CN¥",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "CNY",
    "name_plural": "Chinese yuan"
  },
  {
    "symbol": "CO$",
    "name": "Colombian Peso",
    "symbol_native": "$",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "COP",
    "name_plural": "Colombian pesos"
  },
  {
    "symbol": "₡",
    "name": "Costa Rican Colón",
    "symbol_native": "₡",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "CRC",
    "name_plural": "Costa Rican colóns"
  },
  {
    "symbol": "CV$",
    "name": "Cape Verdean Escudo",
    "symbol_native": "CV$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "CVE",
    "name_plural": "Cape Verdean escudos"
  },
  {
    "symbol": "Kč",
    "name": "Czech Republic Koruna",
    "symbol_native": "Kč",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "CZK",
    "name_plural": "Czech Republic korunas"
  },
  {
    "symbol": "Fdj",
    "name": "Djiboutian Franc",
    "symbol_native": "Fdj",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "DJF",
    "name_plural": "Djiboutian francs"
  },
  {
    "symbol": "Dkr",
    "name": "Danish Krone",
    "symbol_native": "kr",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "DKK",
    "name_plural": "Danish kroner"
  },
  {
    "symbol": "RD$",
    "name": "Dominican Peso",
    "symbol_native": "RD$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "DOP",
    "name_plural": "Dominican pesos"
  },
  {
    "symbol": "DA",
    "name": "Algerian Dinar",
    "symbol_native": "د.ج.‏",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "DZD",
    "name_plural": "Algerian dinars"
  },
  {
    "symbol": "Ekr",
    "name": "Estonian Kroon",
    "symbol_native": "kr",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "EEK",
    "name_plural": "Estonian kroons"
  },
  {
    "symbol": "EGP",
    "name": "Egyptian Pound",
    "symbol_native": "ج.م.‏",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "EGP",
    "name_plural": "Egyptian pounds"
  },
  {
    "symbol": "Nfk",
    "name": "Eritrean Nakfa",
    "symbol_native": "Nfk",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "ERN",
    "name_plural": "Eritrean nakfas"
  },
  {
    "symbol": "Br",
    "name": "Ethiopian Birr",
    "symbol_native": "Br",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "ETB",
    "name_plural": "Ethiopian birrs"
  },
  {
    "symbol": "£",
    "name": "British Pound Sterling",
    "symbol_native": "£",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "GBP",
    "name_plural": "British pounds sterling"
  },
  {
    "symbol": "GEL",
    "name": "Georgian Lari",
    "symbol_native": "GEL",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "GEL",
    "name_plural": "Georgian laris"
  },
  {
    "symbol": "GH₵",
    "name": "Ghanaian Cedi",
    "symbol_native": "GH₵",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "GHS",
    "name_plural": "Ghanaian cedis"
  },
  {
    "symbol": "FG",
    "name": "Guinean Franc",
    "symbol_native": "FG",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "GNF",
    "name_plural": "Guinean francs"
  },
  {
    "symbol": "GTQ",
    "name": "Guatemalan Quetzal",
    "symbol_native": "Q",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "GTQ",
    "name_plural": "Guatemalan quetzals"
  },
  {
    "symbol": "HK$",
    "name": "Hong Kong Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "HKD",
    "name_plural": "Hong Kong dollars"
  },
  {
    "symbol": "HNL",
    "name": "Honduran Lempira",
    "symbol_native": "L",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "HNL",
    "name_plural": "Honduran lempiras"
  },
  {
    "symbol": "kn",
    "name": "Croatian Kuna",
    "symbol_native": "kn",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "HRK",
    "name_plural": "Croatian kunas"
  },
  {
    "symbol": "Ft",
    "name": "Hungarian Forint",
    "symbol_native": "Ft",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "HUF",
    "name_plural": "Hungarian forints"
  },
  {
    "symbol": "Rp",
    "name": "Indonesian Rupiah",
    "symbol_native": "Rp",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "IDR",
    "name_plural": "Indonesian rupiahs"
  },
  {
    "symbol": "₪",
    "name": "Israeli New Sheqel",
    "symbol_native": "₪",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "ILS",
    "name_plural": "Israeli new sheqels"
  },
  {
    "symbol": "Rs",
    "name": "Indian Rupee",
    "symbol_native": "₹",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "INR",
    "name_plural": "Indian rupees"
  },
  {
    "symbol": "IQD",
    "name": "Iraqi Dinar",
    "symbol_native": "د.ع.‏",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "IQD",
    "name_plural": "Iraqi dinars"
  },
  {
    "symbol": "IRR",
    "name": "Iranian Rial",
    "symbol_native": "﷼",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "IRR",
    "name_plural": "Iranian rials"
  },
  {
    "symbol": "Ikr",
    "name": "Icelandic Króna",
    "symbol_native": "kr",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "ISK",
    "name_plural": "Icelandic krónur"
  },
  {
    "symbol": "J$",
    "name": "Jamaican Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "JMD",
    "name_plural": "Jamaican dollars"
  },
  {
    "symbol": "JD",
    "name": "Jordanian Dinar",
    "symbol_native": "د.أ.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "JOD",
    "name_plural": "Jordanian dinars"
  },
  {
    "symbol": "¥",
    "name": "Japanese Yen",
    "symbol_native": "￥",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "JPY",
    "name_plural": "Japanese yen"
  },
  {
    "symbol": "Ksh",
    "name": "Kenyan Shilling",
    "symbol_native": "Ksh",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "KES",
    "name_plural": "Kenyan shillings"
  },
  {
    "symbol": "KHR",
    "name": "Cambodian Riel",
    "symbol_native": "៛",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "KHR",
    "name_plural": "Cambodian riels"
  },
  {
    "symbol": "CF",
    "name": "Comorian Franc",
    "symbol_native": "FC",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "KMF",
    "name_plural": "Comorian francs"
  },
  {
    "symbol": "₩",
    "name": "South Korean Won",
    "symbol_native": "₩",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "KRW",
    "name_plural": "South Korean won"
  },
  {
    "symbol": "KD",
    "name": "Kuwaiti Dinar",
    "symbol_native": "د.ك.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "KWD",
    "name_plural": "Kuwaiti dinars"
  },
  {
    "symbol": "KZT",
    "name": "Kazakhstani Tenge",
    "symbol_native": "тңг.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "KZT",
    "name_plural": "Kazakhstani tenges"
  },
  {
    "symbol": "LB£",
    "name": "Lebanese Pound",
    "symbol_native": "ل.ل.‏",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "LBP",
    "name_plural": "Lebanese pounds"
  },
  {
    "symbol": "SLRs",
    "name": "Sri Lankan Rupee",
    "symbol_native": "SL Re",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "LKR",
    "name_plural": "Sri Lankan rupees"
  },
  {
    "symbol": "Lt",
    "name": "Lithuanian Litas",
    "symbol_native": "Lt",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "LTL",
    "name_plural": "Lithuanian litai"
  },
  {
    "symbol": "Ls",
    "name": "Latvian Lats",
    "symbol_native": "Ls",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "LVL",
    "name_plural": "Latvian lati"
  },
  {
    "symbol": "LD",
    "name": "Libyan Dinar",
    "symbol_native": "د.ل.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "LYD",
    "name_plural": "Libyan dinars"
  },
  {
    "symbol": "MAD",
    "name": "Moroccan Dirham",
    "symbol_native": "د.م.‏",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MAD",
    "name_plural": "Moroccan dirhams"
  },
  {
    "symbol": "MDL",
    "name": "Moldovan Leu",
    "symbol_native": "MDL",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MDL",
    "name_plural": "Moldovan lei"
  },
  {
    "symbol": "MGA",
    "name": "Malagasy Ariary",
    "symbol_native": "MGA",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "MGA",
    "name_plural": "Malagasy Ariaries"
  },
  {
    "symbol": "MKD",
    "name": "Macedonian Denar",
    "symbol_native": "MKD",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MKD",
    "name_plural": "Macedonian denari"
  },
  {
    "symbol": "MMK",
    "name": "Myanma Kyat",
    "symbol_native": "ks",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "MMK",
    "name_plural": "Myanma kyats"
  },
  {
    "symbol": "MOP$",
    "name": "Macanese Pataca",
    "symbol_native": "MOP$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MOP",
    "name_plural": "Macanese patacas"
  },
  {
    "symbol": "MURs",
    "name": "Mauritian Rupee",
    "symbol_native": "MURs",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "MUR",
    "name_plural": "Mauritian rupees"
  },
  {
    "symbol": "MX$",
    "name": "Mexican Peso",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MXN",
    "name_plural": "Mexican pesos"
  },
  {
    "symbol": "RM",
    "name": "Malaysian Ringgit",
    "symbol_native": "RM",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MYR",
    "name_plural": "Malaysian ringgits"
  },
  {
    "symbol": "MTn",
    "name": "Mozambican Metical",
    "symbol_native": "MTn",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "MZN",
    "name_plural": "Mozambican meticals"
  },
  {
    "symbol": "N$",
    "name": "Namibian Dollar",
    "symbol_native": "N$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NAD",
    "name_plural": "Namibian dollars"
  },
  {
    "symbol": "₦",
    "name": "Nigerian Naira",
    "symbol_native": "₦",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NGN",
    "name_plural": "Nigerian nairas"
  },
  {
    "symbol": "C$",
    "name": "Nicaraguan Córdoba",
    "symbol_native": "C$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NIO",
    "name_plural": "Nicaraguan córdobas"
  },
  {
    "symbol": "Nkr",
    "name": "Norwegian Krone",
    "symbol_native": "kr",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NOK",
    "name_plural": "Norwegian kroner"
  },
  {
    "symbol": "NPRs",
    "name": "Nepalese Rupee",
    "symbol_native": "नेरू",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NPR",
    "name_plural": "Nepalese rupees"
  },
  {
    "symbol": "NZ$",
    "name": "New Zealand Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "NZD",
    "name_plural": "New Zealand dollars"
  },
  {
    "symbol": "OMR",
    "name": "Omani Rial",
    "symbol_native": "ر.ع.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "OMR",
    "name_plural": "Omani rials"
  },
  {
    "symbol": "B/.",
    "name": "Panamanian Balboa",
    "symbol_native": "B/.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "PAB",
    "name_plural": "Panamanian balboas"
  },
  {
    "symbol": "S/.",
    "name": "Peruvian Nuevo Sol",
    "symbol_native": "S/.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "PEN",
    "name_plural": "Peruvian nuevos soles"
  },
  {
    "symbol": "₱",
    "name": "Philippine Peso",
    "symbol_native": "₱",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "PHP",
    "name_plural": "Philippine pesos"
  },
  {
    "symbol": "PKRs",
    "name": "Pakistani Rupee",
    "symbol_native": "₨",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "PKR",
    "name_plural": "Pakistani rupees"
  },
  {
    "symbol": "zł",
    "name": "Polish Zloty",
    "symbol_native": "zł",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "PLN",
    "name_plural": "Polish zlotys"
  },
  {
    "symbol": "₲",
    "name": "Paraguayan Guarani",
    "symbol_native": "₲",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "PYG",
    "name_plural": "Paraguayan guaranis"
  },
  {
    "symbol": "QR",
    "name": "Qatari Rial",
    "symbol_native": "ر.ق.‏",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "QAR",
    "name_plural": "Qatari rials"
  },
  {
    "symbol": "RON",
    "name": "Romanian Leu",
    "symbol_native": "RON",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "RON",
    "name_plural": "Romanian lei"
  },
  {
    "symbol": "din.",
    "name": "Serbian Dinar",
    "symbol_native": "дин.",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "RSD",
    "name_plural": "Serbian dinars"
  },
  {
    "symbol": "RUB",
    "name": "Russian Ruble",
    "symbol_native": "руб.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "RUB",
    "name_plural": "Russian rubles"
  },
  {
    "symbol": "RWF",
    "name": "Rwandan Franc",
    "symbol_native": "FR",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "RWF",
    "name_plural": "Rwandan francs"
  },
  {
    "symbol": "SR",
    "name": "Saudi Riyal",
    "symbol_native": "ر.س.‏",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "SAR",
    "name_plural": "Saudi riyals"
  },
  {
    "symbol": "SDG",
    "name": "Sudanese Pound",
    "symbol_native": "SDG",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "SDG",
    "name_plural": "Sudanese pounds"
  },
  {
    "symbol": "Skr",
    "name": "Swedish Krona",
    "symbol_native": "kr",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "SEK",
    "name_plural": "Swedish kronor"
  },
  {
    "symbol": "S$",
    "name": "Singapore Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "SGD",
    "name_plural": "Singapore dollars"
  },
  {
    "symbol": "Ssh",
    "name": "Somali Shilling",
    "symbol_native": "Ssh",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "SOS",
    "name_plural": "Somali shillings"
  },
  {
    "symbol": "SY£",
    "name": "Syrian Pound",
    "symbol_native": "ل.س.‏",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "SYP",
    "name_plural": "Syrian pounds"
  },
  {
    "symbol": "฿",
    "name": "Thai Baht",
    "symbol_native": "฿",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "THB",
    "name_plural": "Thai baht"
  },
  {
    "symbol": "DT",
    "name": "Tunisian Dinar",
    "symbol_native": "د.ت.‏",
    "decimal_digits": 3,
    "rounding": 0,
    "code": "TND",
    "name_plural": "Tunisian dinars"
  },
  {
    "symbol": "T$",
    "name": "Tongan Paʻanga",
    "symbol_native": "T$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "TOP",
    "name_plural": "Tongan paʻanga"
  },
  {
    "symbol": "TL",
    "name": "Turkish Lira",
    "symbol_native": "TL",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "TRY",
    "name_plural": "Turkish Lira"
  },
  {
    "symbol": "TT$",
    "name": "Trinidad and Tobago Dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "TTD",
    "name_plural": "Trinidad and Tobago dollars"
  },
  {
    "symbol": "NT$",
    "name": "New Taiwan Dollar",
    "symbol_native": "NT$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "TWD",
    "name_plural": "New Taiwan dollars"
  },
  {
    "symbol": "TSh",
    "name": "Tanzanian Shilling",
    "symbol_native": "TSh",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "TZS",
    "name_plural": "Tanzanian shillings"
  },
  {
    "symbol": "₴",
    "name": "Ukrainian Hryvnia",
    "symbol_native": "₴",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "UAH",
    "name_plural": "Ukrainian hryvnias"
  },
  {
    "symbol": "USh",
    "name": "Ugandan Shilling",
    "symbol_native": "USh",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "UGX",
    "name_plural": "Ugandan shillings"
  },
  {
    "symbol": "$U",
    "name": "Uruguayan Peso",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "UYU",
    "name_plural": "Uruguayan pesos"
  },
  {
    "symbol": "UZS",
    "name": "Uzbekistan Som",
    "symbol_native": "UZS",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "UZS",
    "name_plural": "Uzbekistan som"
  },
  {
    "symbol": "Bs.F.",
    "name": "Venezuelan Bolívar",
    "symbol_native": "Bs.F.",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "VEF",
    "name_plural": "Venezuelan bolívars"
  },
  {
    "symbol": "₫",
    "name": "Vietnamese Dong",
    "symbol_native": "₫",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "VND",
    "name_plural": "Vietnamese dong"
  },
  {
    "symbol": "FCFA",
    "name": "CFA Franc BEAC",
    "symbol_native": "FCFA",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "XAF",
    "name_plural": "CFA francs BEAC"
  },
  {
    "symbol": "CFA",
    "name": "CFA Franc BCEAO",
    "symbol_native": "CFA",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "XOF",
    "name_plural": "CFA francs BCEAO"
  },
  {
    "symbol": "YR",
    "name": "Yemeni Rial",
    "symbol_native": "ر.ي.‏",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "YER",
    "name_plural": "Yemeni rials"
  },
  {
    "symbol": "R",
    "name": "South African Rand",
    "symbol_native": "R",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "ZAR",
    "name_plural": "South African rand"
  },
  {
    "symbol": "$",
    "name": "East Caribbean dollar",
    "symbol_native": "$",
    "decimal_digits": 2,
    "rounding": 0,
    "code": "XCD",
    "name_plural": "East Caribbean dollars"
  },
  {
    "symbol": "ZK",
    "name": "Zambian Kwacha",
    "symbol_native": "ZK",
    "decimal_digits": 0,
    "rounding": 0,
    "code": "ZMK",
    "name_plural": "Zambian kwachas"
  }
]';

        if ($format == 'json') {
            return $json;
        } elseif ($format == 'array') {
            return json_decode($json, true);
        } else {
            return $json;
        }
    }

    public static function getAllCurrencies()
    {
        return [
            'AED' => [
                'name' => 'UAE Dirham',
                'code' => 784,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'AED ',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'AFN' => [
                'name' => 'Afghani',
                'code' => 971,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '؋',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ALL' => [
                'name' => 'Lek',
                'code' => 8,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'L',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'AMD' => [
                'name' => 'Armenian Dram',
                'code' => 51,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'դր.',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ANG' => [
                'name' => 'Netherlands Antillean Guilder',
                'code' => 532,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ƒ',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'AOA' => [
                'name' => 'Kwanza',
                'code' => 973,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Kz',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ARS' => [
                'name' => 'Argentine Peso',
                'code' => 32,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'AUD' => [
                'name' => 'Australian Dollar',
                'code' => 36,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ' ',
            ],
            'AWG' => [
                'name' => 'Aruban Florin',
                'code' => 533,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ƒ',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'AZN' => [
                'name' => 'Azerbaijanian Manat',
                'code' => 944,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₼',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BAM' => [
                'name' => 'Convertible Mark',
                'code' => 977,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'КМ',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BBD' => [
                'name' => 'Barbados Dollar',
                'code' => 52,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BDT' => [
                'name' => 'Taka',
                'code' => 50,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '৳',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BGN' => [
                'name' => 'Bulgarian Lev',
                'code' => 975,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'лв',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BHD' => [
                'name' => 'Bahraini Dinar',
                'code' => 48,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'ب.د',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BIF' => [
                'name' => 'Burundi Franc',
                'code' => 108,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BMD' => [
                'name' => 'Bermudian Dollar',
                'code' => 60,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BND' => [
                'name' => 'Brunei Dollar',
                'code' => 96,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BOB' => [
                'name' => 'Boliviano',
                'code' => 68,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Bs.',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BOV' => [
                'name' => 'Mvdol',
                'code' => 984,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Bs.',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BRL' => [
                'name' => 'Brazilian Real',
                'code' => 986,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'R$',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'BSD' => [
                'name' => 'Bahamian Dollar',
                'code' => 44,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BTN' => [
                'name' => 'Ngultrum',
                'code' => 64,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Nu.',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BWP' => [
                'name' => 'Pula',
                'code' => 72,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'P',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'BYN' => [
                'name' => 'Belarussian Ruble',
                'code' => 974,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Br',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => ' ',
            ],
            'BZD' => [
                'name' => 'Belize Dollar',
                'code' => 84,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CAD' => [
                'name' => 'Canadian Dollar',
                'code' => 124,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CDF' => [
                'name' => 'Congolese Franc',
                'code' => 976,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CHF' => [
                'name' => 'Swiss Franc',
                'code' => 756,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'CHF ',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CLF' => [
                'name' => 'Unidades de fomento',
                'code' => 990,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'UF',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'CLP' => [
                'name' => 'Chilean Peso',
                'code' => 152,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'CNY' => [
                'name' => 'Yuan Renminbi',
                'code' => 156,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '¥',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'COP' => [
                'name' => 'Colombian Peso',
                'code' => 170,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'CO$',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'CRC' => [
                'name' => 'Costa Rican Colon',
                'code' => 188,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₡',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'CUC' => [
                'name' => 'Peso Convertible',
                'code' => 931,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CUP' => [
                'name' => 'Cuban Peso',
                'code' => 192,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CVE' => [
                'name' => 'Cape Verde Escudo',
                'code' => 132,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'CZK' => [
                'name' => 'Czech Koruna',
                'code' => 203,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Kč',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'DJF' => [
                'name' => 'Djibouti Franc',
                'code' => 262,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fdj',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'DKK' => [
                'name' => 'Danish Krone',
                'code' => 208,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'kr',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'DOP' => [
                'name' => 'Dominican Peso',
                'code' => 214,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'DZD' => [
                'name' => 'Algerian Dinar',
                'code' => 12,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'د.ج',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'EGP' => [
                'name' => 'Egyptian Pound',
                'code' => 818,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ج.م',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ERN' => [
                'name' => 'Nakfa',
                'code' => 232,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Nfk',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ETB' => [
                'name' => 'Ethiopian Birr',
                'code' => 230,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Br',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'EUR' => [
                'name' => 'Euro',
                'code' => 978,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => ' €',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'FJD' => [
                'name' => 'Fiji Dollar',
                'code' => 242,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'FKP' => [
                'name' => 'Falkland Islands Pound',
                'code' => 238,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GBP' => [
                'name' => 'Pound Sterling',
                'code' => 826,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GEL' => [
                'name' => 'Lari',
                'code' => 981,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ლ ',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GHS' => [
                'name' => 'Ghana Cedi',
                'code' => 936,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₵',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GIP' => [
                'name' => 'Gibraltar Pound',
                'code' => 292,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GMD' => [
                'name' => 'Dalasi',
                'code' => 270,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'D',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GNF' => [
                'name' => 'Guinea Franc',
                'code' => 324,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GTQ' => [
                'name' => 'Quetzal',
                'code' => 320,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Q',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'GYD' => [
                'name' => 'Guyana Dollar',
                'code' => 328,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'HKD' => [
                'name' => 'Hong Kong Dollar',
                'code' => 344,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'HNL' => [
                'name' => 'Lempira',
                'code' => 340,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'L',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'HRK' => [
                'name' => 'Croatian Kuna',
                'code' => 191,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'kn',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'HTG' => [
                'name' => 'Gourde',
                'code' => 332,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'G',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'HUF' => [
                'name' => 'Forint',
                'code' => 348,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Ft',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'IDR' => [
                'name' => 'Rupiah',
                'code' => 360,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Rp',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'ILS' => [
                'name' => 'New Israeli Sheqel',
                'code' => 376,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₪',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'INR' => [
                'name' => 'Indian Rupee',
                'code' => 356,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₹',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'IQD' => [
                'name' => 'Iraqi Dinar',
                'code' => 368,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'ع.د',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'IRR' => [
                'name' => 'Iranian Rial',
                'code' => 364,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '﷼',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ISK' => [
                'name' => 'Iceland Krona',
                'code' => 352,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'kr',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'JMD' => [
                'name' => 'Jamaican Dollar',
                'code' => 388,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'JOD' => [
                'name' => 'Jordanian Dinar',
                'code' => 400,
                'precision' => 3,
                'subunit' => 100,
                'symbol' => 'د.ا',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'JPY' => [
                'name' => 'Yen',
                'code' => 392,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => '¥',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KES' => [
                'name' => 'Kenyan Shilling',
                'code' => 404,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'KSh',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KGS' => [
                'name' => 'Som',
                'code' => 417,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'som',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KHR' => [
                'name' => 'Riel',
                'code' => 116,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '៛',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KMF' => [
                'name' => 'Comoro Franc',
                'code' => 174,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KPW' => [
                'name' => 'North Korean Won',
                'code' => 408,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₩',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KRW' => [
                'name' => 'Won',
                'code' => 410,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => '₩',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KWD' => [
                'name' => 'Kuwaiti Dinar',
                'code' => 414,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'د.ك',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KYD' => [
                'name' => 'Cayman Islands Dollar',
                'code' => 136,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'KZT' => [
                'name' => 'Tenge',
                'code' => 398,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '〒',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LAK' => [
                'name' => 'Kip',
                'code' => 418,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₭',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LBP' => [
                'name' => 'Lebanese Pound',
                'code' => 422,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ل.ل',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LKR' => [
                'name' => 'Sri Lanka Rupee',
                'code' => 144,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'LKR',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LRD' => [
                'name' => 'Liberian Dollar',
                'code' => 430,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LSL' => [
                'name' => 'Loti',
                'code' => 426,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'L',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LTL' => [
                'name' => 'Lithuanian Litas',
                'code' => 440,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Lt',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LVL' => [
                'name' => 'Latvian Lats',
                'code' => 428,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Ls',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'LYD' => [
                'name' => 'Libyan Dinar',
                'code' => 434,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'ل.د',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MAD' => [
                'name' => 'Moroccan Dirham',
                'code' => 504,
                'precision' => 2,
                'subunit' => 100,
                //                'symbol'              => 'د.م.',
                'symbol' => 'MAD',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MDL' => [
                'name' => 'Moldovan Leu',
                'code' => 498,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'L',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MGA' => [
                'name' => 'Malagasy Ariary',
                'code' => 969,
                'precision' => 2,
                'subunit' => 5,
                'symbol' => 'Ar',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MKD' => [
                'name' => 'Denar',
                'code' => 807,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ден',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MMK' => [
                'name' => 'Kyat',
                'code' => 104,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ks',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MNT' => [
                'name' => 'Tugrik',
                'code' => 496,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₮',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MOP' => [
                'name' => 'Pataca',
                'code' => 446,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'P',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MRO' => [
                'name' => 'Ouguiya',
                'code' => 478,
                'precision' => 2,
                'subunit' => 5,
                'symbol' => 'UM',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MUR' => [
                'name' => 'Mauritius Rupee',
                'code' => 480,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Rs',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MVR' => [
                'name' => 'Rufiyaa',
                'code' => 462,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'MVR',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MWK' => [
                'name' => 'Kwacha',
                'code' => 454,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'MK',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MXN' => [
                'name' => 'Mexican Peso',
                'code' => 484,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MYR' => [
                'name' => 'Malaysian Ringgit',
                'code' => 458,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'RM',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'MZN' => [
                'name' => 'Mozambique Metical',
                'code' => 943,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'MTn',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'NAD' => [
                'name' => 'Namibia Dollar',
                'code' => 516,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'NGN' => [
                'name' => 'Naira',
                'code' => 566,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₦',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'NIO' => [
                'name' => 'Cordoba Oro',
                'code' => 558,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'C$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'NOK' => [
                'name' => 'Norwegian Krone',
                'code' => 578,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'kr',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'NPR' => [
                'name' => 'Nepalese Rupee',
                'code' => 524,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₨',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'NZD' => [
                'name' => 'New Zealand Dollar',
                'code' => 554,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'OMR' => [
                'name' => 'Rial Omani',
                'code' => 512,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'ر.ع.',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PAB' => [
                'name' => 'Balboa',
                'code' => 590,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'B/.',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PEN' => [
                'name' => 'Nuevo Sol',
                'code' => 604,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'S/.',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PGK' => [
                'name' => 'Kina',
                'code' => 598,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'K',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PHP' => [
                'name' => 'Philippine Peso',
                'code' => 608,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₱',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PKR' => [
                'name' => 'Pakistan Rupee',
                'code' => 586,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₨',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'PLN' => [
                'name' => 'Zloty',
                'code' => 985,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'zł',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => ' ',
            ],
            'PYG' => [
                'name' => 'Guarani',
                'code' => 600,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => '₲',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'QAR' => [
                'name' => 'Qatari Rial',
                'code' => 634,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ر.ق',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'RON' => [
                'name' => 'New Romanian Leu',
                'code' => 946,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Lei',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'RSD' => [
                'name' => 'Serbian Dinar',
                'code' => 941,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'РСД',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'RUB' => [
                'name' => 'Russian Ruble',
                'code' => 643,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => ' ₽',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'RWF' => [
                'name' => 'Rwanda Franc',
                'code' => 646,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'FRw',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SAR' => [
                'name' => 'Saudi Riyal',
                'code' => 682,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ر.س',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SBD' => [
                'name' => 'Solomon Islands Dollar',
                'code' => 90,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SCR' => [
                'name' => 'Seychelles Rupee',
                'code' => 690,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₨',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SDG' => [
                'name' => 'Sudanese Pound',
                'code' => 938,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SEK' => [
                'name' => 'Swedish Krona',
                'code' => 752,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'kr',
                'symbol_first' => false,
                'decimal_mark' => ',',
                'thousands_separator' => ' ',
            ],
            'SGD' => [
                'name' => 'Singapore Dollar',
                'code' => 702,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SHP' => [
                'name' => 'Saint Helena Pound',
                'code' => 654,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SLL' => [
                'name' => 'Leone',
                'code' => 694,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Le',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SOS' => [
                'name' => 'Somali Shilling',
                'code' => 706,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Sh',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SRD' => [
                'name' => 'Surinam Dollar',
                'code' => 968,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SSP' => [
                'name' => 'South Sudanese Pound',
                'code' => 728,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'STD' => [
                'name' => 'Dobra',
                'code' => 678,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Db',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SVC' => [
                'name' => 'El Salvador Colon',
                'code' => 222,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₡',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SYP' => [
                'name' => 'Syrian Pound',
                'code' => 760,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '£S',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'SZL' => [
                'name' => 'Lilangeni',
                'code' => 748,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'E',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'THB' => [
                'name' => 'Baht',
                'code' => 764,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '฿',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TJS' => [
                'name' => 'Somoni',
                'code' => 972,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ЅМ',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TMT' => [
                'name' => 'Turkmenistan New Manat',
                'code' => 934,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'T',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TND' => [
                'name' => 'Tunisian Dinar',
                'code' => 788,
                'precision' => 3,
                'subunit' => 1000,
                'symbol' => 'د.ت',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TOP' => [
                'name' => 'Pa’anga',
                'code' => 776,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'T$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TRY' => [
                'name' => 'Turkish Lira',
                'code' => 949,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₺',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'TTD' => [
                'name' => 'Trinidad and Tobago Dollar',
                'code' => 780,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TWD' => [
                'name' => 'New Taiwan Dollar',
                'code' => 901,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'TZS' => [
                'name' => 'Tanzanian Shilling',
                'code' => 834,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Sh',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'UAH' => [
                'name' => 'Hryvnia',
                'code' => 980,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '₴',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'UGX' => [
                'name' => 'Uganda Shilling',
                'code' => 800,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'USh',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'USD' => [
                'name' => 'US Dollar',
                'code' => 840,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'UYU' => [
                'name' => 'Peso Uruguayo',
                'code' => 858,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'UZS' => [
                'name' => 'Uzbekistan Sum',
                'code' => 860,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => null,
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'VEF' => [
                'name' => 'Bolivar',
                'code' => 937,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'Bs F',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'VND' => [
                'name' => 'Dong',
                'code' => 704,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => '₫',
                'symbol_first' => true,
                'decimal_mark' => ',',
                'thousands_separator' => '.',
            ],
            'VUV' => [
                'name' => 'Vatu',
                'code' => 548,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Vt',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'WST' => [
                'name' => 'Tala',
                'code' => 882,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'T',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XAF' => [
                'name' => 'CFA Franc BEAC',
                'code' => 950,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XAG' => [
                'name' => 'Silver',
                'code' => 961,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'oz t',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XAU' => [
                'name' => 'Gold',
                'code' => 959,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'oz t',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XCD' => [
                'name' => 'East Caribbean Dollar',
                'code' => 951,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XDR' => [
                'name' => 'SDR (Special Drawing Right)',
                'code' => 960,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'SDR',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XOF' => [
                'name' => 'CFA Franc BCEAO',
                'code' => 952,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'XPF' => [
                'name' => 'CFP Franc',
                'code' => 953,
                'precision' => 0,
                'subunit' => 1,
                'symbol' => 'Fr',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'YER' => [
                'name' => 'Yemeni Rial',
                'code' => 886,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '﷼',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ZAR' => [
                'name' => 'Rand',
                'code' => 710,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'R',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ZMW' => [
                'name' => 'Zambian Kwacha',
                'code' => 967,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => 'ZK',
                'symbol_first' => false,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
            'ZWL' => [
                'name' => 'Zimbabwe Dollar',
                'code' => 932,
                'precision' => 2,
                'subunit' => 100,
                'symbol' => '$',
                'symbol_first' => true,
                'decimal_mark' => '.',
                'thousands_separator' => ',',
            ],
        ];
    }
}
