{extends file="$layouts_admin"}

{block name="head"}
    {if !empty($config['google_maps_api_key'])}
        <script>
            (g => {
                var h, a, k, p = "The Google Maps JavaScript API", c = "google", l = "importLibrary", q = "__ib__",
                    m = document, b = window;
                b = b[c] || (b[c] = { });
                var d = b.maps || (b.maps = {}), r = new Set, e = new URLSearchParams,
                    u = () => h || (h = new Promise(async (f, n) => {
                        await (a = m.createElement("script"));
                        e.set("libraries", [...r] + "");
                        for (k in g) e.set(k.replace(/[A-Z]/g, t => "_" + t[0].toLowerCase()), g[k]);
                        e.set("callback", c + ".maps." + q);
                        {literal}
                        a.src = `https://maps.${c}apis.com/maps/api/js?` + e;
                        {/literal}


                        d[q] = f;
                        a.onerror = () => h = n(Error(p + " could not load."));
                        a.nonce = m.querySelector("script[nonce]")?.nonce || "";
                        m.head.append(a)
                    }));
                d[l] ? console.warn(p + " only loads once. Ignoring:", g) : d[l] = (f, ...n) => r.add(f) && u().then(() => d[l](f, ...n))
            })({
                key: "{$config['google_maps_api_key']}",
                v: "weekly",
            });
        </script>
        <style>
            #map {
                height: calc(100vh - 66px);
                width: 100%;
            }

            .map-container {
                width: 100%;
                margin: 20px auto;
                padding: 0 20px;
            }

            .customer-info {
                padding: 4px;
                max-width: 200px;
            }
            #clx-page-content{
                padding: 0;
            }
        </style>
    {/if}
{/block}



{block name="content"}
    <div class="p-0" id="map">

    </div>
{/block}

{block name="script"}
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const mapElement = document.getElementById('map');

            mapElement.innerHTML = '<div class="p-3 text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>';

            axios.get(base_url + 'contacts/map-data').then(response => {
                const contacts = response.data;

                async function initMap() {
                    // Request needed libraries.
                    const { Map } = await google.maps.importLibrary("maps");
                    const { AdvancedMarkerElement } = await google.maps.importLibrary("marker");

                    // Create map centered on US
                    const map = new Map(mapElement, {
                        zoom: 4,
                        center: { lat: 39.8283, lng: -98.5795 },
                        mapId: 'APP_MAP_ID',
                    });

                    // Add markers for each customer
                    contacts.forEach(contact => {

                        const lat = parseFloat(contact.lat);
                        const lng = parseFloat(contact.lon);

                        const marker = new AdvancedMarkerElement({
                            map: map,
                            position: { lat: lat, lng: lng },
                            title: contact.account
                        });

                        // Create info window content
                        {literal}
                        const infoWindow = new google.maps.InfoWindow({
                            content: `
                        <div class="customer-info">
                            <h3>${contact.account}</h3>
                            <div class="mb-2">${contact.email}</div>
                            <div class="mb-2">${contact.phone}</div>
                            <div class="mb-2">${contact.address}</div>
                        </div>
                    `
                        });
                        {/literal}

                        // Add click listener to show info window
                        marker.addListener('click', () => {
                            infoWindow.open(map, marker);
                        });
                    });
                }

                initMap();

            });


        });
    </script>
{/block}


